using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;


namespace MojaDrugaGraXNA
{
    /// <summary>
    /// This is a game component that implements IUpdateable.
    /// </summary>
    public class Prostopadloscian : Microsoft.Xna.Framework.DrawableGameComponent
    {

        private GraphicsDevice gd = null;
        private VertexBuffer buforWerteksow = null;

        private Effect efekt = null;
        public Matrix World = Matrix.Identity;
        private Matrix ViewProjection;

        public Prostopadloscian(Game game,Effect efekt,Matrix ViewProjection,float dx,float dy,float dz,Color? kolor)
            : base(game)
        {
            dx /= 2;
            dy /= 2;
            dz /= 2;

            gd = game.GraphicsDevice;

            //this.efekt = (BasicEffect)efekt.Clone();
            this.efekt = efekt.Clone();

            this.ViewProjection = ViewProjection;

            Vector3[] punkty = new Vector3[8]{
                new Vector3(-dx, -dy, dz),
                new Vector3(dx, -dy, dz),
                new Vector3(dx, dy, dz),
                new Vector3(-dx, dy, dz),
                new Vector3(-dx, -dy, -dz),
                new Vector3(dx, -dy, -dz),
                new Vector3(dx, dy, -dz),
                new Vector3(-dx, dy, -dz)};

            Color kolor1 = (kolor == null) ? Color.Cyan : (Color)kolor;
            Color kolor2 = (kolor == null) ? Color.Magenta : (Color)kolor;
            Color kolor3 = (kolor == null) ? Color.Yellow : (Color)kolor;

            VertexPositionColor[] werteksy = new VertexPositionColor[6 * 4]{ //ZMIANA
                //przednia sciana
                new VertexPositionColor(punkty[3], kolor1),
                new VertexPositionColor(punkty[2], kolor1),
                new VertexPositionColor(punkty[0], kolor1),
                //new VertexPositionColor(punkty[0], kolor1),
                //new VertexPositionColor(punkty[2], kolor1),
                new VertexPositionColor(punkty[1], kolor1),

                //tylnia sciana
                new VertexPositionColor(punkty[7], kolor1),
                new VertexPositionColor(punkty[4], kolor1),
                new VertexPositionColor(punkty[6], kolor1),
                //new VertexPositionColor(punkty[6], kolor1),
                //new VertexPositionColor(punkty[4], kolor1),
                new VertexPositionColor(punkty[5], kolor1),
   
                //gorna sciana
                new VertexPositionColor(punkty[3], kolor2),
                new VertexPositionColor(punkty[7], kolor2),
                new VertexPositionColor(punkty[2], kolor2),
                //new VertexPositionColor(punkty[2], kolor2),
                //new VertexPositionColor(punkty[7], kolor2),
                new VertexPositionColor(punkty[6], kolor2),

                //dolna sciana
                new VertexPositionColor(punkty[0], kolor2),
                new VertexPositionColor(punkty[1], kolor2),
                new VertexPositionColor(punkty[4], kolor2),
                //new VertexPositionColor(punkty[4], kolor2),
                //new VertexPositionColor(punkty[1], kolor2),
                new VertexPositionColor(punkty[5], kolor2),
   
                //lewa sciana
                new VertexPositionColor(punkty[3], kolor3),
                new VertexPositionColor(punkty[0], kolor3),
                new VertexPositionColor(punkty[7], kolor3),
                //new VertexPositionColor(punkty[7], kolor3),
                //new VertexPositionColor(punkty[0], kolor3),
                new VertexPositionColor(punkty[4], kolor3),

                //prawa sciana
                new VertexPositionColor(punkty[1], kolor3),
                new VertexPositionColor(punkty[2], kolor3),
                new VertexPositionColor(punkty[5], kolor3),
                //new VertexPositionColor(punkty[5], kolor3),
                //new VertexPositionColor(punkty[2], kolor3),
                new VertexPositionColor(punkty[6], kolor3)};

            buforWerteksow = new VertexBuffer(gd, VertexPositionColor.VertexDeclaration, werteksy.Count(), BufferUsage.WriteOnly);
            buforWerteksow.SetData<VertexPositionColor>(werteksy);
        }

        /// <summary>
        /// Allows the game component to perform any initialization it needs to before starting
        /// to run.  This is where it can query for any required services and load content.
        /// </summary>
        public override void Initialize()
        {
            // TODO: Add your initialization code here

            base.Initialize();
        }

        /*
        public Matrix World
        {
            get
            {
                return efekt.World;
            }
            set
            {
                efekt.World = value;
            }
        }
        */

        /// <summary>
        /// Allows the game component to update itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        public override void Update(GameTime gameTime)
        {
            //efekt.World = World;
            efekt.Parameters["WorldViewProjection"].SetValue(World * ViewProjection);

            base.Update(gameTime);
        }

        public override void Draw(GameTime gameTime)
        {
            gd.SetVertexBuffer(buforWerteksow);
            
            foreach (EffectPass pass in efekt.CurrentTechnique.Passes)
            {
                pass.Apply();
                
                //gd.DrawPrimitives(PrimitiveType.TriangleList, 0, 6 * 2);
                for(int i=0;i<6;++i)
                    gd.DrawPrimitives(PrimitiveType.TriangleStrip, 4*i, 2);
            }

            base.Draw(gameTime);
        }
    }
}